function ComputerProject1

% Inputs
% n1
% n2
%clear all;

n1 = 5;
n2 = 7;

n1 = 3;
n2 = 3;

pi = 4.0*atan(1.0);

% unit vectors
x_hat = [1 0 0];
y_hat = [0 1 0];
z_hat = [0 0 1];

% define the primitive translation vectors ai

a1 = [1 0 0]; % in units of 'a'
a2 = [.5 2 0]; % in units of 'a'
a3 = [0 0 100]; % in units of 'a'

a1 = [1 0 0]; % in units of 'a'
a2 = [0 2 0]; % in units of 'a'
a3 = [0 0 100]; % in units of 'a'

% calculate the coordinates of each lattice point in direct space
% out to a given (input) distance from the origin
[X,Y,Z] = meshgrid(1:n1,1:n2,1);  % grid corresponding to u1, u2, u3 of equation (1)
Rx = X*dot(a1,x_hat) + Y*dot(a2,x_hat) + Z*dot(a3,x_hat);
Ry = X*dot(a1,y_hat) + Y*dot(a2,y_hat) + Z*dot(a3,y_hat);
Rz = X*dot(a1,z_hat) + Y*dot(a2,z_hat) + Z*dot(a3,z_hat);
% Output the coordinates for each lattice point
fprintf(1,'Real Space Lattice Coordinates [in units of a])\n');
for i=1:n2
    for j=1:n1
        fprintf(1,'%d %d %8.5f %8.5f %8.5f\n',i,j,Rx(i,j),Ry(i,j),Rz(i,j));
    end
end

% plot the lattice points
cla;
handle1 = figure(1);
hold on;
axis equal;

%h=plot(Enum,'bx');% Part (a)
%h=plot(Ean,'b');% Part (a)
h=plot(Rx,Ry,'b+');% Part (b)
%set(gca,'Fontsize',[25])
half_length = sqrt((dot(a1,x_hat)+dot(a2,x_hat)+dot(a3,x_hat))^2 + ...
    (dot(a1,y_hat)+dot(a2,y_hat)+dot(a3,y_hat))^2);
hold on;
x1 = (min(min(Rx))-half_length);
x2 = (max(max(Rx))+half_length);
y1 = (min(min(Ry))-half_length);
y2 = (max(max(Ry))+half_length);
axis([x1 x2 y1 y2]);
axis equal;
xlabel(['X [a]'],'fontsize',14,'fontweight','bold','fontname','Tahoma');
ylabel(['Y [a]'],'fontsize',14,'fontweight','bold','fontname','Tahoma');
title(['Lattice Space'],'fontsize',14,'fontweight','bold','fontname','Tahoma');
saveas(gcf, ['CP1_Lattice.emf']);

% calculate the coordinates of each lattice point in reciprocal space
% out to a given (input) distance from the origin
Vc = dot(a1,cross(a2,a3));
b1 = 2.0*pi*cross(a2,a3)/Vc;
b2 = 2.0*pi*cross(a3,a1)/Vc;
b3 = 2.0*pi*cross(a1,a2)/Vc;

% double check that the 3-D extension works for 2-D
%b1 = [2.0*pi/dot(a1,x_hat) 0  0]
%b2 = [0 2.0*pi/dot(a2,y_hat) 0]
[X,Y,Z] = meshgrid(1:n1,1:n2,1);  % grid corresponding to u1, u2, u3 of equation (1)
Kx = X*dot(b1,x_hat) + Y*dot(b2,x_hat) + Z*dot(b3,x_hat);
Ky = X*dot(b1,y_hat) + Y*dot(b2,y_hat) + Z*dot(b3,y_hat);
Kz = X*dot(b1,z_hat) + Y*dot(b2,z_hat) + Z*dot(b3,z_hat);
handle = figure(2);
h=plot(Kx,Ky,'b+');% Part (b)
fprintf(1,'Reciprocal Space Lattice Coordinates [in units of 1/a])\n');
for i=1:n2
    for j=1:n1
        fprintf(1,'%d %d %8.5f %8.5f %8.5f\n',i,j,Kx(i,j),Ky(i,j),Kz(i,j));
    end
end
half_length = sqrt((dot(b1,x_hat)+dot(b2,x_hat)+dot(b3,x_hat))^2 + ...
    (dot(b1,y_hat)+dot(b2,y_hat)+dot(b3,y_hat))^2);
hold on;
x1 = (min(min(Kx))-half_length);
x2 = (max(max(Kx))+half_length);
y1 = (min(min(Ky))-half_length);
y2 = (max(max(Ky))+half_length);
axis([x1 x2 y1 y2]);
axis equal;
xlabel(['Kx [1/a]'],'fontsize',14,'fontweight','bold','fontname','Tahoma');
ylabel(['Ky [1/a]'],'fontsize',14,'fontweight','bold','fontname','Tahoma');
title(['Reciprocal Lattice Space'],'fontsize',14,'fontweight','bold','fontname','Tahoma');
saveas(gcf, ['CP1_ReciprocalLattice.emf']);

% calculate the coordinates of the corners of the Wigner-Seitz cell
% and the equations of the lines:
% 1) from the origin to the corner,
% 2) from the origin to the center of the edge and 
% 3) from the center of the edge to the corner in the first quadrant (high symmetry directions) 
WS_lines(1:3,1:3) = struct(...
    'x1',0.0,...
    'y1',0.0,...
    'x2',0.0,...
    'y2',0.0,...
    'xc',0.0,...  % midpoint
    'yc',0.0,...
    'zone_x1',0.0,...  % convenient line segment 
    'zone_y1',0.0,...
    'zone_x2',0.0,...
    'zone_y2',0.0,...
    'iMinDist',0,...
    'jMinDist',0,...
    'xMinDist',0.0,...
    'yMinDist',0.0,...
    'perimeter_line',1 ...
    );  
% 1) draw lines to connect a given lattic point ot nearby lattice point
%    8 lines - x1, y1 and x2, y2 define these lines
[WS_lines] = CP1_getZoneLatticeCoordinates(WS_lines, a1, a2, a3);
% 2) At the midpoint and normal to these lines, draw new lines or planes
[WS_lines] = CP1_getZoneMidpointNormals(WS_lines);
% 3) Search for the Corner Coordinates - these define 
%    the smallest volume enclosed is the Wigner-Seitz primitive cell.
[xv, yv] = CP1_getZoneCornerCoordinates(WS_lines,0);
% Compute and ouptut the special lines...
[EdgeMidpoint_X,EdgeMidpoint_Y] = CP1_outputZoneLines(yv,xv,WS_lines(3,3).y2,WS_lines(3,3).x2,'Wigner-Seitz Cell');
CP1_createZoneFigure(1,a1,a2,a3,WS_lines,xv,yv,EdgeMidpoint_X,EdgeMidpoint_Y)


% calculate the coordinates of the corners the first Brillouin zone
% and the equations of the lines:
% 1) from the origin to the corner,
% 2) from the origin to the center of the edge and 
% 3) from the center of the edge to the corner in the first quadrant (high symmetry directions) 
% calculate the coordinates of the corners of the Wigner-Seitz cell
% and the equations of the lines:
% 1) from the origin to the corner,
% 2) from the origin to the center of the edge and 
% 3) from the center of the edge to the corner in the first quadrant (high symmetry directions) 
BZ_lines(1:3,1:3) = struct(...
    'x1',0.0,...
    'y1',0.0,...
    'x2',0.0,...
    'y2',0.0,...
    'xc',0.0,...  % midpoint
    'yc',0.0,...
    'zone_x1',0.0,...  % convenient line segment 
    'zone_y1',0.0,...
    'zone_x2',0.0,...
    'zone_y2',0.0,...
    'iMinDist',0,...
    'jMinDist',0,...
    'xMinDist',0.0,...
    'yMinDist',0.0,...
    'perimeter_line',1 ...
    );  
% 1) draw lines to connect a given lattic point ot nearby lattice point
%    8 lines - x1, y1 and x2, y2 define these lines
[BZ_lines] = CP1_getZoneLatticeCoordinates(BZ_lines, b1, b2, b3);
% 2) At the midpoint and normal to these lines, draw new lines or planes
[BZ_lines] = CP1_getZoneMidpointNormals(BZ_lines);
% 3) Search for the Corner Coordinates - these define 
%    the smallest volume enclosed is the Wigner-Seitz primitive cell.
[xv, yv] = CP1_getZoneCornerCoordinates(BZ_lines,0);
% Compute and ouptut the special lines...
[EdgeMidpoint_X,EdgeMidpoint_Y] = CP1_outputZoneLines(yv,xv,BZ_lines(3,3).y2,BZ_lines(3,3).x2,'Brillouin Zone');
CP1_createZoneFigure(2,b1,b2,b3,BZ_lines,xv,yv,EdgeMidpoint_X,EdgeMidpoint_Y);

