function [EdgeMidpoint_X,EdgeMidpoint_Y] = CP1_outputZoneLines(yv,xv,Q1X,Q1Y,name)

% Compute the following equations of lines:
% 1) from the origin to the corner
% for each corner, compute the equation of a line (I guess he means
% point slope because as is, the value is a 2 point equation...
LineOC_slope = yv/xv;
LineOC_YIntercept = zeros(length(LineOC_slope));
% 2) from the origin to the center of the edge and 
EdgeMidpoint_X = xv(1:length(xv)-1) + (xv(2:length(xv)) - xv(1:length(xv)-1))/2;
EdgeMidpoint_Y = yv(1:length(yv)-1) + (yv(2:length(yv)) - yv(1:length(yv)-1))/2;
Line0EC_slope = EdgeMidpoint_Y./EdgeMidpoint_X;
LineOEC_YIntercept = zeros(length(Line0EC_slope));
% 3) from the center of the edge to the corner in the first quadrant (high symmetry directions) 
%LineECQ1_slope = (EdgeMidpoint_Y-WS_lines(3,3).y2)./(EdgeMidpoint_X-WS_lines(3,3).x2);
LineECQ1_slope = (EdgeMidpoint_Y-Q1Y)./(EdgeMidpoint_X-Q1X);
LineECQ1_YIntercept = EdgeMidpoint_Y - LineECQ1_slope.*EdgeMidpoint_X;

% Output the values
fprintf(1,'Corner Coordinates of the %s\n',name);
fprintf(1,'Corner X             Y\n');
for i=1:length(xv)-1 % last one is a repeat of the first!
fprintf(1,'   %d  %8.5f a    %8.5f a\n',i,xv(i),yv(i));
end
fprintf(1,'\nEquation of Line from Origin to %s Vertex\n',name);
fprintf(1,'Line  Slope        Y Intercept\n');
for i=1:length(LineOC_slope)-1 % last one is a repeat of the first!
fprintf(1,'  %d   %8.5f    %8.5f a\n',i,LineOC_slope(i),LineOC_YIntercept(i));
end
fprintf(1,'\nEquation of Line from Origin to %s Edge Midpoint\n',name);
fprintf(1,'Edge  Slope        Y Intercept\n');
for i=1:length(Line0EC_slope) % last one is a repeat of the first!
fprintf(1,'  %d   %8.5f    %8.5f a\n',i,Line0EC_slope(i),LineOEC_YIntercept(i));
end
fprintf(1,'\nEquation of Line %s Edge Midpoint to Corner In First Quadrant\n',name);
fprintf(1,'Edge  Slope        Y Intercept\n');
for i=1:length(Line0EC_slope) % last one is a repeat of the first!
fprintf(1,'  %d   %8.5f    %8.5f a\n',i,LineECQ1_slope(i),LineECQ1_YIntercept(i));
end
