function [Zone_lines] = CP1_getZoneMidpointNormals(Zone_lines)

% first find the segment that is going to intersect each line...
% is it that point-slope or is it from a neighbor???
for i=-1:1
    for j=-1:1
        if (i == 0 & j == 0)
        else            
            i0 = i+2;
            j0 = j+2;
            % which segment intersects at a point closest to the origin?
            % for line itself
            distance = sqrt(Zone_lines(i0,j0).xc^2 + Zone_lines(i0,j0).yc^2);
            iMinDist = i0;
            jMinDist = j0;
            xMinDist = Zone_lines(i0,j0).xc;
            yMinDist = Zone_lines(i0,j0).yc;
            %plot(xMinDist,yMinDist,'b*');
            % who are the neighbors?
            for ii = -1:1
                for jj = -1:1
                        iNeighbor = i0+ii;
                        jNeighbor = j0+jj;
                    if (iNeighbor == 2 & jNeighbor == 2) % middle point is not a neighbor
                    else
                        if (0 < iNeighbor & iNeighbor < 4 & 0 < jNeighbor & jNeighbor < 4)
                            % neighbor exists!
                            [distanceNeighbor, x, y] = CP1_getIntersectionPoint(...
                                Zone_lines(i0,j0).x1,Zone_lines(i0,j0).x2,...
                                Zone_lines(i0,j0).y1,Zone_lines(i0,j0).y2,...
                                Zone_lines(iNeighbor,jNeighbor).zone_x1,Zone_lines(iNeighbor,jNeighbor).zone_x2,...
                                Zone_lines(iNeighbor,jNeighbor).zone_y1,Zone_lines(iNeighbor,jNeighbor).zone_y2);
                           % plot(x,y,'k+');
                           % fprintf(1,'%d %d %d %d %f\n',i0,j0,iNeighbor,jNeighbor,distanceNeighbor);
                            if (distanceNeighbor < distance)
                                distance = distanceNeighbor;
                                iMinDist = iNeighbor;
                                jMinDist = jNeighbor;
                                xMinDist = x;
                                yMinDist = y;
                            end
                        end
                    end
                end
            end
            %fprintf(1,'%d %d %d %d %f\n\n',i0,j0,iMinDist,jMinDist,distance);
            Zone_lines(iMinDist,jMinDist).perimeter_line = 1;
            %plot(xMinDist,yMinDist,'r+');
            Zone_lines(i0,j0).iMinDist = iMinDist;
            Zone_lines(i0,j0).jMinDist = jMinDist;
            Zone_lines(i0,j0).xMinDist = xMinDist;
            Zone_lines(i0,j0).yMinDist = yMinDist;
            % fprintf(1,'%d %d %d %d %f\n',i0,j0,iMinDist,jMinDist,distance);
        end        
    end
end
