function [Zone_lines] = CP1_getZoneLatticeCoordinates(Zone_lines, a1, a2, a3)

n = 0;
% unit vectors
x_hat = [1 0 0];
y_hat = [0 1 0];
z_hat = [0 0 1];
half_length = sqrt((dot(a1,x_hat)+dot(a2,x_hat)+dot(a3,x_hat))^2 + ...
    (dot(a1,y_hat)+dot(a2,y_hat)+dot(a3,y_hat))^2)/2.0;
for k=0:0
    for i=-1:1
        for j=-1:1
            if (i == 0 & j == 0)
            else
                n = n + 1;
                Zone_lines(i+2,j+2).x1 = 0;
                Zone_lines(i+2,j+2).y1 = 0;
                Zone_lines(i+2,j+2).x2 = i*(dot(a1,x_hat)+dot(a2,x_hat)+dot(a3,x_hat));
                Zone_lines(i+2,j+2).y2 = j*(dot(a1,y_hat)+dot(a2,y_hat)+dot(a3,y_hat));
                Zone_lines(i+2,j+2).x2 = i*dot(a1,x_hat) + j*dot(a2,x_hat) + k*dot(a3,x_hat);
                Zone_lines(i+2,j+2).y2 = i*dot(a1,y_hat) + j*dot(a2,y_hat) + k*dot(a3,y_hat);
                Zone_lines(i+2,j+2).xc = Zone_lines(i+2,j+2).x1 + (Zone_lines(i+2,j+2).x2-Zone_lines(i+2,j+2).x1)/2.0;
                Zone_lines(i+2,j+2).yc = Zone_lines(i+2,j+2).y1 + (Zone_lines(i+2,j+2).y2-Zone_lines(i+2,j+2).y1)/2.0;
                
                if (abs(Zone_lines(i+2,j+2).x2-Zone_lines(i+2,j+2).x1) > 0)
                    slope = ...
                        (Zone_lines(i+2,j+2).y2-Zone_lines(i+2,j+2).y1)/(Zone_lines(i+2,j+2).x2-Zone_lines(i+2,j+2).x1);
                     
                    if (slope ~= 0.0)
                        norm_slope = -1.0/slope;
                        
                        theta = atan(norm_slope);
                        Zone_lines(i+2,j+2).zone_x1 = Zone_lines(i+2,j+2).xc - half_length*cos(theta);
                        Zone_lines(i+2,j+2).zone_x2 = Zone_lines(i+2,j+2).xc + half_length*cos(theta);
                        Zone_lines(i+2,j+2).zone_y1 = Zone_lines(i+2,j+2).yc - half_length*sin(theta);
                        Zone_lines(i+2,j+2).zone_y2 = Zone_lines(i+2,j+2).yc + half_length*sin(theta);
                    else
                        Zone_lines(i+2,j+2).zone_x1 = Zone_lines(i+2,j+2).xc;
                        Zone_lines(i+2,j+2).zone_x2 = Zone_lines(i+2,j+2).xc;
                        Zone_lines(i+2,j+2).zone_y1 = Zone_lines(i+2,j+2).yc - half_length;
                        Zone_lines(i+2,j+2).zone_y2 = Zone_lines(i+2,j+2).yc + half_length;
                        %Zone_lines(i+2,j+2).norm_slope = 0.0; is infinite    
                    end
                else
                    norm_slope = 0.0;
                    Zone_lines(i+2,j+2).zone_x1 = Zone_lines(i+2,j+2).xc - half_length;
                    Zone_lines(i+2,j+2).zone_x2 = Zone_lines(i+2,j+2).xc + half_length;
                    Zone_lines(i+2,j+2).zone_y1 = Zone_lines(i+2,j+2).yc;
                    Zone_lines(i+2,j+2).zone_y2 = Zone_lines(i+2,j+2).yc;
                end
            end        
        end
    end
end
