function [distance, x, y] = CP1_getIntersectionPoint(...
    Line1_x1,Line1_x2,Line1_y1,Line1_y2,...
    Line2_x1,Line2_x2,Line2_y1,Line2_y2)

%Line1_x1
%Line1_x2
%Line1_y1
%Line1_y2
%Line2_x1
%Line2_x2
%Line2_y1
%Line2_y2

if (abs(Line1_x2-Line1_x1) > 0)
    % slope exists for Line1
    m1 = (Line1_y2-Line1_y1)/(Line1_x2-Line1_x1);
    if (Line2_x1 == Line2_x2)
        % slope of normal (Line2) is infinite
        x = Line2_x1;
        y = m1*x + Line1_y1 - m1*Line1_x1;
    else
        m2 = (Line2_y2-Line2_y1)/(Line2_x2-Line2_x1);
        x = (Line2_y1 - Line1_y1 + m1*Line1_x1 - m2*Line2_x1)/(m1-m2);
        y = m1 * x + Line1_y1 - m1*Line1_x1;
    end     
    %if (WS_lines(i+2,j+2).x1 < x && x < WS_lines(i+2,j+2).x2)
    %if (WS_lines(i1+2,i1+2).x1 < x && x < WS_lines(i1+2,i1+2).x2)
    % intersection exists                
    % find distance
    distance = sqrt(x^2 + y^2);
    %plot(x,y,'k*');
    %   end
    %end % does Line1 intersect Line2 ?
else               
    % slope exists for Line2
    m1 = (Line2_y2-Line2_y1)/(Line2_x2-Line2_x1);
    if (Line1_x1 == Line1_x2)
        % slope of normal (Line1) is infinite
        x = Line1_x1;
        y = m1*x + Line2_y1 - m1*Line2_x1;
    else
        m2 = (Line1_y2-Line1_y1)/(Line1_x2-Line1_x1);
        x = (Line1_y1 - Line2_y1 + m1*Line2_x1 - m2*Line1_x1)/(m1-m2);
        y = m1 * x + Line2_y1 - m1*Line2_x1;
    end     
    % intersection exists                
    % find distance
    distance = sqrt(x^2 + y^2);
    %plot(x,y,'r*');
end    
