function CP1_createZoneFigure(itype,a1,a2,a3,WS_lines,xv,yv,EdgeMidpoint_X,EdgeMidpoint_Y)

% unit vectors
x_hat = [1 0 0];
y_hat = [0 1 0];
z_hat = [0 0 1];

half_length = sqrt((dot(a1,x_hat)+dot(a2,x_hat)+dot(a3,x_hat))^2 + ...
    (dot(a1,y_hat)+dot(a2,y_hat)+dot(a3,y_hat))^2);

if (itype == 1)
name = 'Wigner-Seitz Cell';
xname = 'X [a]';
yname = 'Y [a]';
ofile = 'CP1_WignerSeitzCell.emf';
ifig = 3;
else
name = 'Brillouin Zone';
xname = 'K_X [1/a]';
yname = 'K_Y [1/a]';
ofile = 'CP1_BrillouinZone.emf';
ifig = 4;
end
    
% Create Wigner-Seitz Cell Figure
handle = figure(ifig);
cla;
hold on;
fill(xv,yv,[.9 .9 .6]); % Wigner-Seitz Cell polynomial

Lattice_X = WS_lines(1,1).x2;
Lattice_Y = WS_lines(1,1).y2;
for i=-1:1
    for j=-1:1
        if (i == 0 & j == 0)
        else
            Lattice_X = [Lattice_X;WS_lines(i+2,j+2).x2];
            Lattice_Y = [Lattice_Y;WS_lines(i+2,j+2).y2];
            %,'.','Color',[0 0 .8],'MarkerSize',20); % center
            %plot(WS_lines(i+2,j+2).x2,WS_lines(i+2,j+2).y2,'b.','MarkerSize',20); % lattic corner           
            %plot(WS_lines(i+2,j+2).xc,WS_lines(i+2,j+2).yc,'+','Color',[.4 .4 0],...
            %    'MarkerSize',10,'linewidth',2); % midpoint
        end        
    end
end


plot(WS_lines(1,1).x1,WS_lines(1,1).y1,'k.','MarkerSize',20); % center
plot(Lattice_X,Lattice_Y,'b.','MarkerSize',20); % lattic corner           
plot(EdgeMidpoint_X,EdgeMidpoint_Y,'+','Color',[.4 .4 0],...
                'MarkerSize',10,'linewidth',2); % midpoint


           % plot the point-to-point vectors
for i=-1:1
    for j=-1:1
        if (i == 0 & j == 0)
        else
            plot([WS_lines(i+2,j+2).x1 WS_lines(i+2,j+2).x2],...
                [WS_lines(i+2,j+2).y1 WS_lines(i+2,j+2).y2],'--b');
            plot([WS_lines(i+2,j+2).zone_x1 WS_lines(i+2,j+2).zone_x2],...
                [WS_lines(i+2,j+2).zone_y1 WS_lines(i+2,j+2).zone_y2],'Color',[0 .8 0]);
            % plot(WS_lines(i+2,j+2).x2,WS_lines(i+2,j+2).y2,'b+');            
            % plot(WS_lines(i+2,j+2).xc,WS_lines(i+2,j+2).yc,'r.','MarkerSize',20);
        end        
    end
end


% redraw so on top
plot(WS_lines(1,1).x1,WS_lines(1,1).y1,'k.','MarkerSize',20); % center
plot(Lattice_X,Lattice_Y,'b.','MarkerSize',20); % lattic corner           
plot(EdgeMidpoint_X,EdgeMidpoint_Y,'+','Color',[.4 .4 0],...
                'MarkerSize',10,'linewidth',2); % midpoint

if (itype == 2)            
plot([0 EdgeMidpoint_X(length(EdgeMidpoint_X))],...
    [0 EdgeMidpoint_Y(length(EdgeMidpoint_Y))],'r','linewidth',2);
plot([EdgeMidpoint_X(length(EdgeMidpoint_X)) EdgeMidpoint_X(length(EdgeMidpoint_X)-1)],...
     [EdgeMidpoint_Y(length(EdgeMidpoint_Y)) EdgeMidpoint_Y(length(EdgeMidpoint_Y)-1)],...
     'r','linewidth',2);
plot([EdgeMidpoint_X(length(EdgeMidpoint_X)-1) 0],...
    [EdgeMidpoint_Y(length(EdgeMidpoint_Y)-1) 0],'r','linewidth',2);

text(WS_lines(1,1).x1-.2,WS_lines(1,1).y1,' \Gamma','HorizontalAlignment','right',...
    'fontsize',12,'fontweight','bold','fontname','Tahoma');            
text(EdgeMidpoint_X(length(EdgeMidpoint_X)),EdgeMidpoint_Y(length(EdgeMidpoint_Y)),...
    ' X','fontsize',10,'fontweight','bold','fontname','Tahoma');            
text(EdgeMidpoint_X(length(EdgeMidpoint_X)-1),EdgeMidpoint_Y(length(EdgeMidpoint_Y)-1),...
    ' M','fontsize',10,'fontweight','bold','fontname','Tahoma');          
end

%axis([-2.5 2.5 -2.5 2.5]);
axis([-half_length half_length -half_length half_length]);
axis equal;
if (itype == 1)
legend('Lattice Center','Lattice Corner','Edge Midpoint',0);
else
legend('Reciprocal Lattice Center','Reciprocal Lattice Corner','Edge Midpoint',0);
end
xlabel([xname],'fontsize',14,'fontweight','bold','fontname','Tahoma');
ylabel([yname],'fontsize',14,'fontweight','bold','fontname','Tahoma');
title([name],'fontsize',14,'fontweight','bold','fontname','Tahoma');


saveas(gcf, [ofile]);
